<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/?alias=linee-guida-per-luso-del-logo-geecom
    */

    class MessaggioChat {
        private $db;
        private $id;
        private $idDocumento;
        private $idUtente;
        private $testo;
        private $dataCreazione;
        
        public function __construct($db, $id, $idDocumento=0, $idUtente=0, $testo="", $dataCreazione="") {
            $this->db = $db;
            $this->id = $id;
            $this->idDocumento   = $idDocumento;
            $this->idUtente      = $idUtente;
            $this->testo         = $testo;
            $this->dataCreazione = $dataCreazione;
        }

        public function crea() {
            $dataCreazione = date("Y-m-d H:i");
            $query = "INSERT INTO `geecD_messaggiChat` (`id`, `idDocumento`, `idUtente`, `testo`, `dataCreazione`) VALUES (NULL, '$this->idDocumento', '$this->idUtente', '$this->testo','$dataCreazione');";
            return $this->db->eseguiQueryCreazione($query);
        }
        
        public function modifica() {
            $query = "UPDATE `geecD_messaggiChat` SET idDocumento= '$this->idDocumento', idUtente = '$this->idUtente', testo = '$this->testo' WHERE id = $this->id; ";
            $this->db->eseguiQueryScrittura($query);
        }
        
        public function elimina() {
            $this->db->eseguiQueryCancellazione("geecD_messaggiChat",$this->id);
        }
        
        public function caricaDatiDalDatabase() {
            $datiMessaggio = $this->db->leggiSingolaRiga("geecD_messaggiChat",$this->id);
            $this->idDocumento   = $datiMessaggio["idDocumento"];
            $this->idUtente      = $datiMessaggio["idUtente"];
            $this->testo         = $datiMessaggio["testo"];
            $this->dataCreazione = $datiMessaggio["dataCreazione"];
        }
        
        function eliminaDomanda($idDomanda) {
            $this->db->eseguiQueryCancellazione("geecD_messaggiChat",$idDomanda);
        }
        
        // getter & setter
        
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getIdDocumento() {
            return $this->idDocumento;
        }

        public function getIdUtente() {
            return $this->idUtente;
        }

        public function getTesto() {
            return $this->testo;
        }

        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setIdDocumento($idDocumento): void {
            $this->idDocumento = $idDocumento;
        }

        public function setIdUtente($idUtente): void {
            $this->idUtente = $idUtente;
        }

        public function setTesto($testo): void {
            $this->testo = $testo;
        }

    }